

/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file       Port_Cfg.c
  \brief      This file contains all Port Configuration Parameters to be used \n
              as Pwm channels. All values must be Port pin indexes from Port  \n
              Port Base Address. 
  \author     Freescale Semiconductor
  \author     r01160
  \author     Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date       4/14/2008 5:02:30 PM
  \warning    User must be aware about which GPIO pins shall be used as Pwm channels.
  
  * History:
  
*/
/****************************************************************************************/

/** Reference to Pwm Cfg file to get maximum Pwm Channels configured            */
#include "Pwm_Cfg.h"


#if (PWM_INIT_DELAY == OFF)
   /** This structure holds all Pwm configuration parameters for signal generation */ 
	Pwm_ChannelConfigType Pwm_ChannelConfig[PWM_MAX_CHANNELS] =
	{
	   {
		    (uint32_t)(PWM_CHANNEL_0),      /* Pwm Channel Id                      */
		    (uint32_t)(PORTB_PIN_0),        /* Port B, Pin 0                       */
		    (uint32_t)SET_PERIOD_AT_150HZ, /* Period running at 150Hz             */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 50% Duty Cycle                      */
		    (uint32_t)0x08,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */  
		    (uint32_t)ADC_CHANNEL_28,       /* Adc Channel 28 assigned             */
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    },
		{
	        (uint32_t)(PWM_CHANNEL_1),       /* Pwm Channel Id                     */
	        (uint32_t)(PORTB_PIN_1),         /* Port B, Pin 1                      */
		    (uint32_t)SET_PERIOD_AT_150HZ, /* Period running at 150Hz            */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 50% Duty Cycle                      */
		    (uint32_t)0x10,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */
		    (uint32_t)ADC_CHANNEL_29,       /* Adc Channel 29 assigned            */  
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    },	
	    {
	        (uint32_t)(PWM_CHANNEL_2),       /* Pwm Channel Id                     */
	        (uint32_t)(PORTB_PIN_2),         /* Port B, Pin 2                      */
		    (uint32_t)SET_PERIOD_AT_150HZ,  /* Period running at 150Hz            */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 50% Duty Cycle                      */
		    (uint32_t)0x18,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */  
		    (uint32_t)ADC_CHANNEL_30,       /* Adc Channel 30 assigned            */
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    },
	    
	    {
	        (uint32_t)(PWM_CHANNEL_3),       /* Pwm Channel Id                     */
	        (uint32_t)(PORTB_PIN_3),         /* Port B, Pin 3                      */
		    (uint32_t)SET_PERIOD_AT_150HZ,  /* Period running at 150Hz            */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 50% Duty Cycle                      */
		    (uint32_t)0x20,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */  
		    (uint32_t)ADC_CHANNEL_31,       /* Adc Channel 31 assigned             */
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    }
	    
	};
#else
	 /** This structure holds all Pwm configuration parameters for signal generation */ 
	Pwm_ChannelConfigType Pwm_ChannelConfig[] =
	{
	   {
		    (uint8_t)(PWM_CHANNEL_0),       /* Pwm Channel Id                     */
		    (uint8_t)(PORTB_PIN_0),         /* Port B, Pin 0                      */
		    (uint32_t)SET_PERIOD_AT_150HZ,  /* Period running at 150Hz            */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 5% Duty Cycle                      */
		    (uint32_t)0x08,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */  
		    (uint32_t)ADC_CHANNEL_28,       /* Adc Channel 28 assigned            */
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    },
		{
	        (uint8_t)(PWM_CHANNEL_1),       /* Pwm Channel Id                     */
	        (uint8_t)(PORTB_PIN_1),         /* Port B, Pin 1                      */
		    (uint32_t)SET_PERIOD_AT_150HZ, /* Period running at 150Hz            */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 5% Duty Cycle                      */
		    (uint32_t)0x10,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */  
		    (uint32_t)ADC_CHANNEL_29,        /* Adc Channel 29 assigned            */
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    },	
	    
	    {
	        (uint8_t)(PWM_CHANNEL_2),       /* Pwm Channel Id                     */
	        (uint8_t)(PORTB_PIN_2),         /* Port B, Pin 2                      */
		    (uint32_t)SET_PERIOD_AT_150HZ,  /* Period running at 150Hz            */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 5% Duty Cycle                      */
		    (uint32_t)0x18,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */  
		    (uint32_t)ADC_CHANNEL_30,       /* Adc Channel 30 assigned             */
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    },
	    
	    {
	        (uint8_t)(PWM_CHANNEL_3),       /* Pwm Channel Id                     */
	        (uint8_t)(PORTB_PIN_3),         /* Port B, Pin 3                      */
		    (uint32_t)SET_PERIOD_AT_150HZ,  /* Period running at 150Hz            */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 5% Duty Cycle                      */
		    (uint32_t)0x20,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */  
		    (uint32_t)ADC_CHANNEL_31,       /* Adc Channel 31 assigned            */
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    },		
	    
	    {
	        (uint8_t)(PWM_CHANNEL_4),       /* Pwm Channel Id                     */
	        (uint8_t)(PORTB_PIN_4),         /* Port B, Pin 4                      */
		     (uint32_t)SET_PERIOD_AT_150HZ, /* Period running at 150Hz            */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 5% Duty Cycle                      */
		    (uint32_t)0x28,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */  
		    (uint32_t)ADC_CHANNEL_32,       /* Adc Channel 32 assigned            */
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    },
	    {
	        (uint8_t)(PWM_CHANNEL_5),       /* Pwm Channel Id                     */
	        (uint8_t)(PORTB_PIN_5),         /* Port B, Pin 5                      */
		    (uint32_t)SET_PERIOD_AT_150HZ,  /* Period running at 150Hz            */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 5% Duty Cycle                      */
		    (uint32_t)0x30,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */  
		    (uint32_t)ADC_CHANNEL_33,        /* Adc Channel 33 assigned            */
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    },
	    {
	        (uint8_t)(PWM_CHANNEL_6),       /* Pwm Channel Id                     */
	        (uint8_t)(PORTB_PIN_6),         /* Port B, Pin 6                      */
		    (uint32_t)SET_PERIOD_AT_150HZ,  /* Period running at 150Hz            */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 50% Duty Cycle                     */
		    (uint32_t)0x38,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */
		    (uint32_t)ADC_CHANNEL_34,       /* Adc Channel 34 assigned            */  
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    },
	    {
	        (uint8_t)(PWM_CHANNEL_7),       /* Pwm Channel Id                     */
	        (uint8_t)(PORTB_PIN_7),         /* Port B, Pin 7                      */
		    (uint32_t)SET_PERIOD_AT_150HZ,  /* Period running at 150Hz            */
		    (uint32_t)DTY_AT_50P_WITH_150HZ,/* 5% Duty Cycle                      */
		    (uint32_t)0x40,                 /* Duty Counter Initialized           */
		 #if (DIAGNOSTICS == ON)            /* Check if Diagnostics is needed     */
		    (uint32_t)ADC_CHANNEL_35,       /* Adc Channel 35 assigned            */  
		    (uint32_t)0x10,                 /* Triggers Adc when 50% duty reached */
		    (uint32_t)0x00                  /* Reset ADC buffer                   */
		 #endif   
	    }				
	    
	};

#endif
